
*******************************************************************************************************************
* Table 2. Explaining Headline Inflation Shocks, 2020-2022 
*******************************************************************************************************************

* Please note that the replication code for Table 2 does not include four variables that are proprietary (our license for the data for these variables does not allow for sharing with non-subscribers): backlogs of work, the Harper index, the Baltic dry index, and supply delivery times.

***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

***************************************************************
* Data work
***************************************************************

* Relative price fluctuations (supply fluctuations)
g z			= CPI - Median
* 12-month average
gen z_12ma	= (1/12)*(z + z[_n-1] + z[_n-2] + z[_n-3] + z[_n-4] + z[_n-5] + z[_n-6] + z[_n-7] + z[_n-8] + z[_n-9] + z[_n-10] + z[_n-11])

* Variables

cap drop pgap
gen pgap = Median-pe

gen y = pgap
g x = vu_12ma
g x2 = x^2
g x3 = x^3
g x4 = x^4

* Sample dummies

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1968m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))

g sample13 = 1 if (sample1==1 | sample3==1)

* Overall sample
keep if (t>=tm(1968m1)) & (t<=tm(2022m9))

* Redefine energy price inflation and food price inflation in relative terms (relative to median).

replace energy	= energy - Median
replace food	= food - Median
replace allcars	= allcars - Median

***************************************************************
* Explaining relative price fluctuations
***************************************************************

cd "results\tables"

local ctitle = " "

reg z energy if t>=tm(2020m1), r
outreg2 using "T2A-HIS.xls", ctitle("`ctitle'") ///
addstat("Rbar-squared", e(r2_a)) ///
dec(3) label replace

foreach var in food GSCPI sG allcars stringency_index ///
{
	reg z `var' if t>=tm(2020m1), r
	outreg2 using "T2A-HIS.xls", ctitle("`ctitle'") ///
	addstat("Rbar-squared", e(r2_a)) ///
	dec(3) label append
}

cd `main'